---insert new path.
---@param path string
local function newPath(path)
    package.path = package.path .. ";./" .. path .. "/?.lua"
end

newPath("core/lexer")
newPath("core/parser")
newPath("core/evaluator")

local Lexer = require("lexer")
local Parser = require("parser")
local Evaluator = require("evaluator")

local file, err = io.open("main.k")
if not file then
    print(err)
    return
end

local lex = Lexer.new()
local tokens = lex:tokenize(file:read("*a"))
file:close()

local par = Parser.new()
local node = par:parse(tokens)

local result = Evaluator:process(node)
if result.kind == "Error" then
    print("\27[31m" .. result.value .. "\27[0m")
end